//Falcon-180B DATASET v1.0 Category: Encryption ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define KEY_SIZE 16
#define BLOCK_SIZE 8

struct block {
    unsigned char data[BLOCK_SIZE];
};

struct key {
    unsigned char value[KEY_SIZE];
};

void generate_key(struct key *key) {
    srand(time(NULL));
    for (int i = 0; i < KEY_SIZE; i++) {
        key->value[i] = rand() % 256;
    }
}

void encrypt(struct block *block, struct key *key) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        block->data[i] ^= key->value[i % KEY_SIZE];
    }
}

void decrypt(struct block *block, struct key *key) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        block->data[i] ^= key->value[i % KEY_SIZE];
    }
}

int main() {
    struct key key;
    generate_key(&key);

    char message[500] = "Hello, world!";
    int message_size = strlen(message);
    int block_count = message_size / BLOCK_SIZE;
    if (message_size % BLOCK_SIZE!= 0) {
        block_count++;
    }

    struct block blocks[block_count];
    for (int i = 0; i < block_count; i++) {
        int offset = i * BLOCK_SIZE;
        int length = BLOCK_SIZE;
        if (i == block_count - 1) {
            length = message_size % BLOCK_SIZE;
        }
        memcpy(blocks[i].data, message + offset, length);
    }

    for (int i = 0; i < block_count; i++) {
        encrypt(&blocks[i], &key);
    }

    for (int i = 0; i < block_count; i++) {
        printf("%s\n", blocks[i].data);
    }

    for (int i = 0; i < block_count; i++) {
        decrypt(&blocks[i], &key);
    }

    printf("\nDecrypted message: %s\n", message);

    return 0;
}