//GPT-4o-mini DATASET v1.0 Category: System administration ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#define LOG_FILE "cpu_usage.log"
#define SAMPLE_SIZE 10

void log_cpu_usage(float usage[], int count);
void calculate_statistics(float usage[], int count);
float average(float usage[], int count);
float standard_deviation(float usage[], int count, float avg);
void print_usage(float usage[], int count);

int main() {
    float cpu_usage[SAMPLE_SIZE];
    srand(time(NULL));

    FILE *file = fopen(LOG_FILE, "w");
    if (file == NULL) {
        perror("Could not open log file");
        return EXIT_FAILURE;
    }

    printf("Starting CPU usage logging...\n");
    
    // Simulate gathering CPU usage over time
    for (int i = 0; i < SAMPLE_SIZE; i++) {
        cpu_usage[i] = (float)(rand() % 101); // Random CPU usage between 0 and 100
        fprintf(file, "Sample %d: CPU Usage = %.2f%%\n", i + 1, cpu_usage[i]);
        sleep(1); // Sleep for 1 second between samples
    }

    fclose(file);
    printf("Logging complete. Data written to %s\n", LOG_FILE);

    // Perform analysis on the sampled data
    calculate_statistics(cpu_usage, SAMPLE_SIZE);

    return EXIT_SUCCESS;
}

void log_cpu_usage(float usage[], int count) {
    FILE *file = fopen(LOG_FILE, "a");
    if (file == NULL) {
        perror("Could not open log file");
        return;
    }
    for (int i = 0; i < count; i++) {
        fprintf(file, "CPU Usage Sample %d: %.2f%%\n", i + 1, usage[i]);
    }
    fclose(file);
}

void calculate_statistics(float usage[], int count) {
    float avg = average(usage, count);
    float stddev = standard_deviation(usage, count, avg);

    printf("Statistics:\n");
    printf("Average CPU Usage: %.2f%%\n", avg);
    printf("Standard Deviation: %.2f%%\n", stddev);
    print_usage(usage, count);
}

float average(float usage[], int count) {
    float sum = 0.0;
    for (int i = 0; i < count; i++) {
        sum += usage[i];
    }
    return sum / count;
}

float standard_deviation(float usage[], int count, float avg) {
    float sum = 0.0;
    for (int i = 0; i < count; i++) {
        sum += (usage[i] - avg) * (usage[i] - avg);
    }
    return sqrt(sum / count);
}

void print_usage(float usage[], int count) {
    printf("CPU Usage Samples:\n");
    for (int i = 0; i < count; i++) {
        printf("Sample %d: %.2f%%\n", i + 1, usage[i]);
    }
}