//Gemma-7B DATASET v1.0 Category: Game of Life ; Style: grateful
#include <stdio.h>
#include <stdlib.h>

#define MAX_CELLS 10

int main()
{
    int cells[MAX_CELLS] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int i, j, k, alive_cells = 0;

    // Seed the random number generator
    srand(time(NULL));

    // Create a random number of alive cells
    for (k = 0; k < MAX_CELLS; k++)
    {
        if (rand() % 2 == 0)
        {
            cells[k] = 1;
            alive_cells++;
        }
    }

    // Print the initial state of the cells
    printf("Initial state:\n");
    for (i = 0; i < MAX_CELLS; i++)
    {
        printf("%d ", cells[i]);
    }
    printf("\n");

    // Simulate the Game of Life
    for (i = 0; i < 10; i++)
    {
        // Calculate the number of alive neighbors for each cell
        for (j = 0; j < MAX_CELLS; j++)
        {
            int num_alive_neighbors = 0;
            for (k = 0; k < MAX_CELLS; k++)
            {
                if (k != j && cells[k] == 1)
                {
                    num_alive_neighbors++;
                }
            }

            // Apply the Game of Life rules
            if (cells[j] == 1)
            {
                if (num_alive_neighbors < 2 || num_alive_neighbors > 3)
                {
                    cells[j] = 0;
                }
            }
            else
            {
                if (num_alive_neighbors == 3)
                {
                    cells[j] = 1;
                }
            }
        }

        // Print the state of the cells after each iteration
        printf("State after iteration %d:\n", i);
        for (j = 0; j < MAX_CELLS; j++)
        {
            printf("%d ", cells[j]);
        }
        printf("\n");
    }

    // Print the final state of the cells
    printf("Final state:\n");
    for (i = 0; i < MAX_CELLS; i++)
    {
        printf("%d ", cells[i]);
    }
    printf("\n");

    // Calculate the number of alive cells in the final state
    alive_cells = 0;
    for (i = 0; i < MAX_CELLS; i++)
    {
        if (cells[i] == 1)
        {
            alive_cells++;
        }
    }

    // Print the number of alive cells in the final state
    printf("Number of alive cells in the final state: %d\n", alive_cells);

    return 0;
}