//GPT-4o-mini DATASET v1.0 Category: Networking ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>

#define PORT 8080
#define BUFFER_SIZE 1024

void detective_message(int socket) {
    char *message = "Holmes: Watson, I've deduced that the artifact is located in the museum's east wing! Send reinforcements.";
    send(socket, message, strlen(message), 0);
    printf("Sent: %s\n", message);
}

void watson_reply(int socket) {
    char buffer[BUFFER_SIZE] = {0};
    int valread = recv(socket, buffer, BUFFER_SIZE, 0);
    if (valread > 0) {
        printf("Received: %s\n", buffer);
    }
}

int main() {
    int server_fd, new_socket;
    struct sockaddr_in address;
    int opt = 1;
    int addrlen = sizeof(address);

    // Creating socket file descriptor
    if ((server_fd = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
        perror("Socket creation failed");
        exit(EXIT_FAILURE);
    }

    // Forcefully attaching socket to the port
    if (setsockopt(server_fd, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt))) {
        perror("Error setting socket options");
        exit(EXIT_FAILURE);
    }

    address.sin_family = AF_INET;
    address.sin_addr.s_addr = INADDR_ANY;
    address.sin_port = htons(PORT);

    // Bind the socket
    if (bind(server_fd, (struct sockaddr *)&address, sizeof(address)) < 0) {
        perror("Bind failed");
        exit(EXIT_FAILURE);
    }

    // Listening for incoming connections
    if (listen(server_fd, 3) < 0) {
        perror("Listen failed");
        exit(EXIT_FAILURE);
    }

    printf("Holmes' Network Server is running... Waiting for Watson's connection...\n");

    // Accept a client connection
    if ((new_socket = accept(server_fd, (struct sockaddr *)&address, (socklen_t*)&addrlen)) < 0) {
        perror("Accept failed");
        exit(EXIT_FAILURE);
    }

    // Watson's message reception
    watson_reply(new_socket);

    // Holmes sends a message to Watson
    detective_message(new_socket);

    // Close the socket
    close(new_socket);
    close(server_fd);
    return 0;
}