//Falcon-180B DATASET v1.0 Category: Intrusion detection system ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <pcap.h>

#define MAX_PKT_SIZE 65535
#define SNAPLEN 65535
#define TRUE 1
#define FALSE 0

//callback function for packet processing
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    printf("Packet received\n");
}

//function to start packet capture
void *start_capture(void *arg) {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    handle = pcap_open_live(arg, SNAPLEN, 1, 0, errbuf);

    if (handle == NULL) {
        fprintf(stderr, "Error: %s\n", errbuf);
        exit(1);
    }

    pcap_loop(handle, -1, packet_handler, NULL);

    pcap_close(handle);
    return NULL;
}

int main(int argc, char *argv[]) {
    if (argc!= 2) {
        fprintf(stderr, "Usage: %s <network_interface>\n", argv[0]);
        exit(1);
    }

    pthread_t thread_id;
    pthread_create(&thread_id, NULL, start_capture, argv[1]);

    printf("Press any key to stop packet capture...\n");
    getchar();

    pthread_cancel(thread_id);
    pthread_join(thread_id, NULL);

    return 0;
}