//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: protected
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

typedef struct {
    double x, y;
} Point;

typedef struct {
    Point a, b;
} LineSegment;

typedef struct {
    Point center;
    double radius;
} Circle;

double distance(Point p1, Point p2) {
    return sqrt(pow(p2.x - p1.x, 2) + pow(p2.y - p1.y, 2));
}

double area(Circle c) {
    return M_PI * c.radius * c.radius;
}

double circumference(Circle c) {
    return 2 * M_PI * c.radius;
}

int main() {
    // Create a point
    Point p1 = {1.0, 2.0};

    // Create a line segment
    LineSegment l1 = {{0.0, 0.0}, {10.0, 10.0}};

    // Create a circle
    Circle c1 = {{5.0, 5.0}, 3.0};

    // Print the point
    printf("Point: (%.1f, %.1f)\n", p1.x, p1.y);

    // Print the line segment
    printf("Line segment: (%.1f, %.1f) to (%.1f, %.1f)\n", l1.a.x, l1.a.y, l1.b.x, l1.b.y);

    // Print the circle
    printf("Circle: center at (%.1f, %.1f), radius %.1f\n", c1.center.x, c1.center.y, c1.radius);

    // Calculate the distance between two points
    double d = distance(p1, l1.a);
    printf("Distance between point and line segment: %.1f\n", d);

    // Calculate the area of the circle
    double a = area(c1);
    printf("Area of circle: %.1f\n", a);

    // Calculate the circumference of the circle
    double c = circumference(c1);
    printf("Circumference of circle: %.1f\n", c);

    return 0;
}