//GEMINI-pro DATASET v1.0 Category: Database simulation ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of records in the database
#define MAX_RECORDS 100

// Define the maximum size of a record
#define MAX_RECORD_SIZE 100

// Define the structure of a record
typedef struct {
    int id;
    char name[50];
    char address[50];
    char phone[50];
} record_t;

// Define the database
record_t database[MAX_RECORDS];

// Define the current number of records in the database
int num_records = 0;

// Function to add a record to the database
void add_record(record_t record) {
    // Check if the database is full
    if (num_records == MAX_RECORDS) {
        printf("Error: The database is full.\n");
        return;
    }

    // Add the record to the database
    database[num_records] = record;

    // Increment the number of records in the database
    num_records++;
}

// Function to find a record in the database by id
record_t* find_record_by_id(int id) {
    // Iterate over the records in the database
    for (int i = 0; i < num_records; i++) {
        // Check if the record's id matches the given id
        if (database[i].id == id) {
            // Return the record
            return &database[i];
        }
    }

    // Return NULL if the record was not found
    return NULL;
}

// Function to delete a record from the database by id
void delete_record_by_id(int id) {
    // Find the record in the database
    record_t* record = find_record_by_id(id);

    // Check if the record was found
    if (record == NULL) {
        printf("Error: The record was not found.\n");
        return;
    }

    // Delete the record from the database
    for (int i = record - database; i < num_records - 1; i++) {
        database[i] = database[i + 1];
    }

    // Decrement the number of records in the database
    num_records--;
}

// Function to print the database
void print_database() {
    // Iterate over the records in the database
    for (int i = 0; i < num_records; i++) {
        // Print the record
        printf("Record %d:\n", i + 1);
        printf("    ID: %d\n", database[i].id);
        printf("    Name: %s\n", database[i].name);
        printf("    Address: %s\n", database[i].address);
        printf("    Phone: %s\n", database[i].phone);
    }
}

// Main function
int main() {
    // Add some records to the database
    add_record((record_t) { .id = 1, .name = "John Doe", .address = "123 Main Street", .phone = "555-1212" });
    add_record((record_t) { .id = 2, .name = "Jane Doe", .address = "456 Elm Street", .phone = "555-1213" });
    add_record((record_t) { .id = 3, .name = "Bill Smith", .address = "789 Oak Street", .phone = "555-1214" });

    // Print the database
    print_database();

    // Find a record in the database by id
    record_t* record = find_record_by_id(2);

    // Check if the record was found
    if (record == NULL) {
        printf("Error: The record was not found.\n");
    } else {
        // Print the record
        printf("Record found:\n");
        printf("    ID: %d\n", record->id);
        printf("    Name: %s\n", record->name);
        printf("    Address: %s\n", record->address);
        printf("    Phone: %s\n", record->phone);
    }

    // Delete a record from the database by id
    delete_record_by_id(1);

    // Print the database
    print_database();

    return 0;
}