//Falcon-180B DATASET v1.0 Category: Expense Tracker ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_EXPENSES 100

typedef struct expense {
    char name[50];
    double amount;
} Expense;

Expense expenses[MAX_EXPENSES];
int num_expenses = 0;

void add_expense(char* name, double amount) {
    if (num_expenses >= MAX_EXPENSES) {
        printf("Error: Too many expenses.\n");
        return;
    }

    strcpy(expenses[num_expenses].name, name);
    expenses[num_expenses].amount = amount;
    num_expenses++;
}

void print_expenses() {
    printf("Expenses:\n");
    for (int i = 0; i < num_expenses; i++) {
        printf("%s: $%.2f\n", expenses[i].name, expenses[i].amount);
    }
}

void delete_expense(int index) {
    if (index < 0 || index >= num_expenses) {
        printf("Error: Invalid expense index.\n");
        return;
    }

    num_expenses--;
    for (int i = index; i < num_expenses; i++) {
        strcpy(expenses[i].name, expenses[i+1].name);
        expenses[i].amount = expenses[i+1].amount;
    }
}

int main() {
    add_expense("Groceries", 50.00);
    add_expense("Rent", 1000.00);
    add_expense("Utilities", 200.00);

    print_expenses();

    delete_expense(1);

    print_expenses();

    return 0;
}