//Falcon2-11B DATASET v1.0 Category: Searching algorithm ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Function to perform binary search
int binarySearch(int arr[], int low, int high, int key) {
    if (high >= low) {
        int mid = low + (high - low) / 2;

        // If the element is present at the middle itself
        if (arr[mid] == key)
            return mid;

        // If element is smaller than mid, then it can only
        // be present in the left subarray
        if (arr[mid] > key)
            return binarySearch(arr, low, mid - 1, key);

        // Else the element can only be present in the right subarray
        return binarySearch(arr, mid + 1, high, key);
    }

    // We reach here when element is not present in array
    return -1;
}

// Function to perform linear search
int linearSearch(int arr[], int n, int key) {
    for (int i = 0; i < n; i++) {
        if (arr[i] == key)
            return i;
    }

    return -1;
}

int main() {
    int arr[] = { 2, 3, 4, 10, 40 };
    int n = sizeof(arr) / sizeof(arr[0]);

    int key = 10;

    // Perform binary search
    int result = binarySearch(arr, 0, n - 1, key);

    if (result == -1) {
        // Element not found
        printf("Element not found in array");
    } else {
        // Element found at index %d", result);
    }

    // Perform linear search
    int result2 = linearSearch(arr, n, key);

    if (result2 == -1) {
        // Element not found
        printf("Element not found in array");
    } else {
        // Element found at index %d", result2);
    }

    return 0;
}