//Gemma-7B DATASET v1.0 Category: URL Sanitizer ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_URL_LENGTH 255

void sanitize_url(char *url) {
  char *p = url;
  char *q = url;

  // Remove leading and trailing spaces
  while (*p == ' ') {
    p++;
  }
  while (*q != '\0' && *q != ' ') {
    q++;
  }

  // Normalize case
  for (p = url; *p != '\0'; p++) {
    if (*p >= 'a' && *p <= 'z') {
      *p -= 32;
    }
  }

  // Remove invalid characters
  p = url;
  while (*p) {
    if (!((*p >= 'a' && *p <= 'z') || (*p >= 'A' && *p <= 'Z') || (*p >= '0' && *p <= '9') || (*p == '.') || (*p == '-') || (*p == '_') || (*p == '+') || (*p == '='))) {
      *p = '\0';
    }
    p++;
  }

  // Trim trailing spaces
  while (*q == ' ') {
    q--;
  }

  // Copy the sanitized URL to the original pointer
  memcpy(url, q, strlen(q) + 1);

  // Null-terminate the string
  url[MAX_URL_LENGTH - 1] = '\0';
}

int main() {
  char url[MAX_URL_LENGTH] = "This is a sample URL with invalid characters and spaces.";

  sanitize_url(url);

  printf("Sanitized URL: %s\n", url);

  return 0;
}