//MISTRAL-7B DATASET v1.0 Category: Product Inventory System ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define MAX_PRODUCTS 50

typedef struct {
    char name[50];
    int stock;
    float price;
} Product;

Product inventory[MAX_PRODUCTS];
int num_products = 0;

void add_product(const char *name, int stock, float price) {
    if (num_products >= MAX_PRODUCTS) {
        printf("Error: Maximum number of products reached.\n");
        return;
    }

    strcpy(inventory[num_products].name, name);
    inventory[num_products].stock = stock;
    inventory[num_products].price = price;

    num_products++;
}

void remove_product(const char *name) {
    int i;

    for (i = 0; i < num_products; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            for (int j = i; j < num_products - 1; j++) {
                inventory[j] = inventory[j + 1];
            }
            num_products--;
            return;
        }
    }

    printf("Error: Product not found.\n");
}

void display_inventory() {
    printf("\nProduct Inventory\n");
    printf("------------------\n");

    for (int i = 0; i < num_products; i++) {
        printf("\n%s\n", inventory[i].name);
        printf("Stock: %d\n", inventory[i].stock);
        printf("Price: %.2f\n", inventory[i].price);
    }
}

void search_product(const char *name) {
    int i;

    for (i = 0; i < num_products; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            printf("\nProduct Found:\n");
            printf("Name: %s\n", inventory[i].name);
            printf("Stock: %d\n", inventory[i].stock);
            printf("Price: %.2f\n", inventory[i].price);
            return;
        }
    }

    printf("Error: Product not found.\n");
}

int main() {
    add_product("Laptop", 10, 899.99);
    add_product("Monitor", 5, 299.99);
    add_product("Mouse", 20, 9.99);

    display_inventory();

    search_product("Monitor");

    remove_product("Mouse");

    display_inventory();

    return 0;
}