//GEMINI-pro DATASET v1.0 Category: Procedurally Generated Maze ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 20
#define HEIGHT 10

int maze[HEIGHT][WIDTH];

void generateMaze() {
  for (int i = 0; i < HEIGHT; i++) {
    for (int j = 0; j < WIDTH; j++) {
      maze[i][j] = 1;
    }
  }

  int x = 0, y = 0;
  int dx[] = {0, 1, 0, -1};
  int dy[] = {1, 0, -1, 0};
  int direction = 0;

  while (1) {
    maze[y][x] = 0;

    int nextX = x + dx[direction];
    int nextY = y + dy[direction];

    if (nextX >= 0 && nextX < WIDTH && nextY >= 0 && nextY < HEIGHT && maze[nextY][nextX] == 1) {
      x = nextX;
      y = nextY;
    } else {
      direction = (direction + 1) % 4;
      if (maze[y][x] == 0) {
        break;
      }
    }
  }
}

void printMaze() {
  for (int i = 0; i < HEIGHT; i++) {
    for (int j = 0; j < WIDTH; j++) {
      printf("%c", maze[i][j] == 1 ? '#' : ' ');
    }
    printf("\n");
  }
}

int main() {
  srand(time(NULL));
  generateMaze();
  printMaze();
  return 0;
}