//Gemma-7B DATASET v1.0 Category: Memory Game ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_CARS 5
#define NUM_ROUNDS 3

typedef struct Car
{
    char name[20];
    int speed;
    int location;
    int direction;
} Car;

void initialiseCars(Car *cars)
{
    for (int i = 0; i < NUM_CARS; i++)
    {
        cars[i].name[0] = 'A' + i;
        cars[i].speed = rand() % 10 + 1;
        cars[i].location = rand() % 100;
        cars[i].direction = rand() % 2;
    }
}

void moveCars(Car *cars)
{
    for (int i = 0; i < NUM_CARS; i++)
    {
        switch (cars[i].direction)
        {
            case 0:
                cars[i].location++;
                break;
            case 1:
                cars[i].location--;
                break;
        }

        if (cars[i].location >= 100)
        {
            cars[i].direction = 1;
            cars[i].location = 0;
        }

        if (cars[i].location <= 0)
        {
            cars[i].direction = 0;
            cars[i].location = 99;
        }
    }
}

int main()
{
    srand(time(NULL));

    Car cars[NUM_CARS];
    initialiseCars(cars);

    for (int round = 0; round < NUM_ROUNDS; round++)
    {
        moveCars(cars);
    }

    for (int i = 0; i < NUM_CARS; i++)
    {
        printf("Car %c location: %d\n", cars[i].name[0], cars[i].location);
    }

    return 0;
}