//Falcon-180B DATASET v1.0 Category: Digital Watermarking ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define N 8
#define M 16

// Generate watermark
void generate_watermark(int watermark[N][M]) {
    int i, j;
    for (i = 0; i < N; i++) {
        for (j = 0; j < M; j++) {
            watermark[i][j] = rand() % 256;
        }
    }
}

// Embedding the watermark
void embedding(int image[N][M], int watermark[N][M]) {
    int i, j;
    for (i = 0; i < N; i++) {
        for (j = 0; j < M; j++) {
            image[i][j] = (image[i][j] + watermark[i][j]) % 256;
        }
    }
}

// Extracting the watermark
void extract_watermark(int image[N][M], int watermark[N][M]) {
    int i, j;
    for (i = 0; i < N; i++) {
        for (j = 0; j < M; j++) {
            watermark[i][j] = (image[i][j] - watermark[i][j]) % 256;
        }
    }
}

// Displaying the image
void display(int image[N][M]) {
    int i, j;
    for (i = 0; i < N; i++) {
        for (j = 0; j < M; j++) {
            printf("%d ", image[i][j]);
        }
        printf("\n");
    }
}

int main() {
    int image[N][M], watermark[N][M];

    // Generate image and watermark
    generate_watermark(watermark);
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < M; j++) {
            image[i][j] = rand() % 256;
        }
    }

    // Embedding the watermark
    embedding(image, watermark);

    // Displaying the watermarked image
    printf("Watermarked image:\n");
    display(image);

    // Extracting the watermark
    extract_watermark(image, watermark);

    // Displaying the extracted watermark
    printf("\nExtracted watermark:\n");
    display(watermark);

    return 0;
}