//Falcon2-11B DATASET v1.0 Category: Password Strength Checker ; Style: complete
#include <stdio.h>
#include <stdbool.h>
#include <string.h>

// Function to check the strength of a password
bool checkPasswordStrength(char* password, int minLength) {
    // Minimum length of the password
    if (strlen(password) < minLength) {
        printf("Password is too short\n");
        return false;
    }

    // Password should contain at least one uppercase letter, one lowercase letter, one digit and one special character
    bool hasUppercase = false;
    bool hasLowercase = false;
    bool hasDigit = false;
    bool hasSpecialChar = false;

    // Check for uppercase letters
    for (int i = 0; i < strlen(password); i++) {
        if (isupper(password[i])) {
            hasUppercase = true;
        }
    }

    // Check for lowercase letters
    for (int i = 0; i < strlen(password); i++) {
        if (islower(password[i])) {
            hasLowercase = true;
        }
    }

    // Check for digits
    for (int i = 0; i < strlen(password); i++) {
        if (isdigit(password[i])) {
            hasDigit = true;
        }
    }

    // Check for special characters
    for (int i = 0; i < strlen(password); i++) {
        if (!isalnum(password[i])) {
            hasSpecialChar = true;
        }
    }

    if (!hasUppercase ||!hasLowercase ||!hasDigit ||!hasSpecialChar) {
        printf("Password is too weak\n");
        return false;
    }

    printf("Password is strong\n");
    return true;
}

int main() {
    // Input password and minimum length
    char* password = "Abc123$";
    int minLength = 8;

    // Check password strength
    if (checkPasswordStrength(password, minLength)) {
        printf("Password strength is strong\n");
    } else {
        printf("Password strength is weak\n");
    }

    return 0;
}