//Falcon-180B DATASET v1.0 Category: Time Travel Simulator ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>

#define NUM_THREADS 3

struct thread_data {
    int thread_id;
    int start_time;
    int end_time;
};

void *time_travel(void *arg) {
    struct thread_data *data = (struct thread_data *) arg;
    int thread_id = data->thread_id;
    int start_time = data->start_time;
    int end_time = data->end_time;

    printf("Thread %d starting at time %d\n", thread_id, start_time);
    sleep(start_time);

    printf("Thread %d traveling back in time to %d\n", thread_id, end_time);
    sleep(end_time);

    printf("Thread %d ending at time %d\n", thread_id, end_time);
    pthread_exit(NULL);
}

int main() {
    pthread_t threads[NUM_THREADS];
    struct thread_data data[NUM_THREADS];

    int i;
    for (i = 0; i < NUM_THREADS; i++) {
        data[i].thread_id = i + 1;
        data[i].start_time = i * 1000;
        data[i].end_time = (i + 1) * 1000;

        int ret = pthread_create(&threads[i], NULL, time_travel, &data[i]);
        if (ret!= 0) {
            printf("Error creating thread %d\n", i + 1);
            exit(1);
        }
    }

    for (i = 0; i < NUM_THREADS; i++) {
        int ret = pthread_join(threads[i], NULL);
        if (ret!= 0) {
            printf("Error joining thread %d\n", i + 1);
            exit(1);
        }
    }

    printf("All threads have completed their time travel\n");
    return 0;
}