//Falcon-180B DATASET v1.0 Category: Weather simulation ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_DAYS 7
#define NUM_HOURS 24
#define NUM_MINUTES 60
#define NUM_SECONDS 60
#define NUM_WEATHER_TYPES 5

enum {
    SUNNY,
    CLOUDY,
    RAINY,
    SNOWY,
    STORMY
};

struct Weather {
    int temperature;
    char weatherType;
};

void generateWeather(struct Weather *weather, int day) {
    srand(time(NULL));
    weather->temperature = rand() % 50 + 10;
    switch (day) {
        case 0:
            weather->weatherType = SUNNY;
            break;
        case 1:
            weather->weatherType = CLOUDY;
            break;
        case 2:
            weather->weatherType = RAINY;
            break;
        case 3:
            weather->weatherType = SNOWY;
            break;
        case 4:
            weather->weatherType = STORMY;
            break;
        default:
            weather->weatherType = SUNNY;
            break;
    }
}

void printWeather(struct Weather weather) {
    switch (weather.weatherType) {
        case SUNNY:
            printf("Sunny, %d degrees\n", weather.temperature);
            break;
        case CLOUDY:
            printf("Cloudy, %d degrees\n", weather.temperature);
            break;
        case RAINY:
            printf("Rainy, %d degrees\n", weather.temperature);
            break;
        case SNOWY:
            printf("Snowy, %d degrees\n", weather.temperature);
            break;
        case STORMY:
            printf("Stormy, %d degrees\n", weather.temperature);
            break;
    }
}

int main() {
    struct Weather weather[NUM_DAYS];
    int i, j;

    for (i = 0; i < NUM_DAYS; i++) {
        for (j = 0; j < NUM_HOURS; j++) {
            generateWeather(&weather[i], i);
            printWeather(weather[i]);
        }
    }

    return 0;
}