//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

#define BUF_SIZE 1024
#define PORT 8080

int main(int argc, char *argv[]) {
    int sock;
    struct sockaddr_in server_addr;
    char *message = "Hello, world!";
    int message_len = strlen(message);
    char buffer[BUF_SIZE];

    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
        fprintf(stderr, "Error creating socket\n");
        exit(1);
    }

    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);

    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        fprintf(stderr, "Error connecting to server\n");
        close(sock);
        exit(1);
    }

    if (send(sock, message, message_len, 0) == -1) {
        fprintf(stderr, "Error sending message\n");
        close(sock);
        exit(1);
    }

    memset(buffer, 0, BUF_SIZE);
    if (recv(sock, buffer, BUF_SIZE, 0) == -1) {
        fprintf(stderr, "Error receiving response\n");
        close(sock);
        exit(1);
    }

    printf("Response: %s\n", buffer);

    close(sock);
    return 0;
}