//GEMINI-pro DATASET v1.0 Category: Smart home automation ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

// Define the smart home devices
typedef enum {
    LIGHT,
    FAN,
    AC,
    TV
} device_type;

typedef struct {
    device_type type;
    char *name;
    bool state;
} device;

// Create an array of devices
device devices[] = {
    {LIGHT, "Living Room Light", false},
    {FAN, "Bedroom Fan", false},
    {AC, "Kitchen AC", false},
    {TV, "Living Room TV", false}
};

// Print the status of all devices
void print_devices() {
    for (int i = 0; i < sizeof(devices) / sizeof(device); i++) {
        printf("%s: %s\n", devices[i].name, devices[i].state ? "On" : "Off");
    }
}

// Turn a device on or off
void toggle_device(char *name, bool state) {
    for (int i = 0; i < sizeof(devices) / sizeof(device); i++) {
        if (strcmp(devices[i].name, name) == 0) {
            devices[i].state = state;
            printf("%s is now %s\n", devices[i].name, state ? "On" : "Off");
            return;
        }
    }

    printf("Device not found\n");
}

// Main function
int main() {
    // Print the initial status of all devices
    printf("Initial status of devices:\n");
    print_devices();

    // Turn on the living room light
    toggle_device("Living Room Light", true);

    // Turn off the bedroom fan
    toggle_device("Bedroom Fan", false);

    // Print the updated status of all devices
    printf("\nUpdated status of devices:\n");
    print_devices();

    return 0;
}