//GEMINI-pro DATASET v1.0 Category: System process viewer ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>

#define MAX_LINE_LENGTH 1024

void print_usage() {
    printf("Usage: process_viewer [options]\n");
    printf("Options:\n");
    printf("  -h, --help\t\tPrint this help message and exit\n");
    printf("  -p, --pid\t\tSpecify the PID of the process to view\n");
}

int main(int argc, char *argv[]) {
    int pid = -1;
    int option;

    while ((option = getopt(argc, argv, "hp:")) != -1) {
        switch (option) {
            case 'h':
                print_usage();
                return 0;
            case 'p':
                pid = atoi(optarg);
                break;
            default:
                fprintf(stderr, "Unknown option: %c\n", optopt);
                print_usage();
                return 1;
        }
    }

    if (pid == -1) {
        fprintf(stderr, "No PID specified\n");
        print_usage();
        return 1;
    }

    char proc_path[MAX_LINE_LENGTH];

    snprintf(proc_path, MAX_LINE_LENGTH, "/proc/%d/status", pid);

    FILE *proc_file = fopen(proc_path, "r");
    if (proc_file == NULL) {
        fprintf(stderr, "Failed to open process file: %s\n", proc_path);
        return 1;
    }

    char line[MAX_LINE_LENGTH];

    while (fgets(line, MAX_LINE_LENGTH, proc_file)) {
        // Process the line here...
    }

    fclose(proc_file);

    return 0;
}