//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define DAYS_IN_WEEK 7

typedef struct {
    char day[10];
    float temperature; // in Celsius
    float humidity;    // in percentage
    float precipitation; // in mm
} WeatherDay;

void generateWeatherData(WeatherDay *weather, int dayIndex) {
    // Randomize temperature between -10 to 35 Celsius
    weather[dayIndex].temperature = (rand() % 461) / 10.0 - 10.0;

    // Randomize humidity between 0 to 100 percent
    weather[dayIndex].humidity = rand() % 101;

    // Randomize precipitation between 0 to 20 mm
    weather[dayIndex].precipitation = (rand() % 201) / 10.0; // 0 to 20.0 mm
}

void printWeatherReport(WeatherDay *weather) {
    printf("\nWeekly Weather Report:\n");
    printf("-------------------------------------------------\n");
    printf("| Day       | Temperature | Humidity  | Precip. |\n");
    printf("-------------------------------------------------\n");
    for (int i = 0; i < DAYS_IN_WEEK; i++) {
        printf("| %-9s | %-11.1f | %-8.1f | %-7.1f |\n",
            weather[i].day, 
            weather[i].temperature, 
            weather[i].humidity, 
            weather[i].precipitation);
    }
    printf("-------------------------------------------------\n");
}

void calculateAverages(WeatherDay *weather) {
    float totalTemp = 0, totalHumidity = 0, totalPrecip = 0;
    for (int i = 0; i < DAYS_IN_WEEK; i++) {
        totalTemp += weather[i].temperature;
        totalHumidity += weather[i].humidity;
        totalPrecip += weather[i].precipitation;
    }
    printf("Average Temperature: %.1f°C\n", totalTemp / DAYS_IN_WEEK);
    printf("Average Humidity: %.1f%%\n", totalHumidity / DAYS_IN_WEEK);
    printf("Total Precipitation: %.1f mm\n", totalPrecip);
}

int main() {
    WeatherDay weather[DAYS_IN_WEEK];
    const char* daysOfWeek[] = {"Monday", "Tuesday", "Wednesday", 
                                 "Thursday", "Friday", "Saturday", "Sunday"};
    
    // Initialize random number generator
    srand(time(NULL));

    // Initialize weather data for each day
    for (int i = 0; i < DAYS_IN_WEEK; i++) {
        snprintf(weather[i].day, sizeof(weather[i].day), "%s", daysOfWeek[i]);
        generateWeatherData(weather, i);
    }

    // Print weather report
    printWeatherReport(weather);

    // Calculate and print averages
    calculateAverages(weather);

    return 0;
}