//GEMINI-pro DATASET v1.0 Category: File Encyptor ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

// Define the encryption key
#define KEY "ENCRYPTION_KEY"

// Function to encrypt a file
int encrypt_file(char *file_name) {
    // Get file size
    struct stat file_stat;
    stat(file_name, &file_stat);
    size_t file_size = file_stat.st_size;

    // Read file contents into buffer
    char *file_content = malloc(file_size);
    FILE *file = fopen(file_name, "rb");
    fread(file_content, 1, file_size, file);
    fclose(file);

    // Encrypt file contents
    int i;
    for (i = 0; i < file_size; i++) {
        file_content[i] ^= KEY[i % strlen(KEY)];
    }

    // Write encrypted contents to a new file
    char *encrypted_file_name = malloc(strlen(file_name) + 5);
    sprintf(encrypted_file_name, "%s.enc", file_name);
    file = fopen(encrypted_file_name, "wb");
    fwrite(file_content, 1, file_size, file);
    fclose(file);

    // Free memory
    free(file_content);
    free(encrypted_file_name);

    return 0;
}

// Function to decrypt a file
int decrypt_file(char *file_name) {
    // Get file size
    struct stat file_stat;
    stat(file_name, &file_stat);
    size_t file_size = file_stat.st_size;

    // Read file contents into buffer
    char *file_content = malloc(file_size);
    FILE *file = fopen(file_name, "rb");
    fread(file_content, 1, file_size, file);
    fclose(file);

    // Decrypt file contents
    int i;
    for (i = 0; i < file_size; i++) {
        file_content[i] ^= KEY[i % strlen(KEY)];
    }

    // Write decrypted contents to a new file
    char *decrypted_file_name = malloc(strlen(file_name) - 4);
    strncpy(decrypted_file_name, file_name, strlen(file_name) - 4);
    file = fopen(decrypted_file_name, "wb");
    fwrite(file_content, 1, file_size, file);
    fclose(file);

    // Free memory
    free(file_content);
    free(decrypted_file_name);

    return 0;
}

// Main function
int main(int argc, char **argv) {
    // Check if enough arguments are provided
    if (argc < 2) {
        printf("Usage: %s <file_name> [encrypt|decrypt]\n", argv[0]);
        return 1;
    }

    // Get file name and operation
    char *file_name = argv[1];
    char *operation = argv[2];

    // Check if file exists
    if (access(file_name, F_OK) != 0) {
        printf("File %s does not exist.\n", file_name);
        return 1;
    }

    // Check if operation is valid
    if (strcmp(operation, "encrypt") != 0 && strcmp(operation, "decrypt") != 0) {
        printf("Invalid operation: %s. Valid operations are 'encrypt' and 'decrypt'.\n", operation);
        return 1;
    }

    // Perform encryption or decryption
    int result;
    if (strcmp(operation, "encrypt") == 0) {
        result = encrypt_file(file_name);
    } else {
        result = decrypt_file(file_name);
    }

    // Check if operation was successful
    if (result != 0) {
        printf("Operation failed.\n");
        return 1;
    }

    // Print success message
    printf("Operation successful.\n");

    return 0;
}