//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

// Process structure
typedef struct Process {
    int pid;        // Process ID
    int bt;         // Burst time
    int at;         // Arrival time
    int ct;         // Completion time
    int wt;         // Waiting time
    int tt;         // Turnaround time
    int rem_bt;     // Remaining burst time
} Process;

// Function to find the waiting time for all processes
void findWaitingTime(Process processes[], int n) {
    processes[0].wt = 0;
    for (int i = 1; i < n; i++) {
        processes[i].wt = processes[i - 1].ct - processes[i].at;
        if (processes[i].wt < 0) {
            processes[i].wt = 0;
        }
    }
}

// Function to find the turnaround time for all processes
void findTurnaroundTime(Process processes[], int n) {
    for (int i = 0; i < n; i++) {
        processes[i].tt = processes[i].ct - processes[i].at;
    }
}

// Function to find the average waiting time for all processes
float findAvgWaitingTime(Process processes[], int n) {
    float avg_wt = 0;
    for (int i = 0; i < n; i++) {
        avg_wt += processes[i].wt;
    }
    return avg_wt / n;
}

// Function to find the average turnaround time for all processes
float findAvgTurnaroundTime(Process processes[], int n) {
    float avg_tt = 0;
    for (int i = 0; i < n; i++) {
        avg_tt += processes[i].tt;
    }
    return avg_tt / n;
}

// Function to sort processes according to their arrival times
void sortByArrivalTime(Process processes[], int n) {
    for (int i = 0; i < n - 1; i++) {
        for (int j = 0; j < n - i - 1; j++) {
            if (processes[j].at > processes[j + 1].at) {
                Process temp = processes[j];
                processes[j] = processes[j + 1];
                processes[j + 1] = temp;
            }
        }
    }
}

// Function to print the results
void printResults(Process processes[], int n) {
    printf("PID\tAT\tBT\tCT\tWT\tTT\n");
    for (int i = 0; i < n; i++) {
        printf("%d\t%d\t%d\t%d\t%d\t%d\n", processes[i].pid, processes[i].at, processes[i].bt, processes[i].ct, processes[i].wt, processes[i].tt);
    }
}

// Main function
int main() {
    // Create a set of processes
    Process processes[] = {
        {1, 1, 6},
        {2, 2, 4},
        {3, 3, 3},
        {4, 4, 2},
        {5, 5, 1}
    };
    int n = sizeof(processes) / sizeof(processes[0]);

    // Sort processes according to their arrival times
    sortByArrivalTime(processes, n);

    // Find the completion times for all processes
    int current_time = 0;
    for (int i = 0; i < n; i++) {
        if (current_time < processes[i].at) {
            current_time = processes[i].at;
        }
        processes[i].ct = current_time + processes[i].bt;
        current_time = processes[i].ct;
    }

    // Find the waiting times and turnaround times for all processes
    findWaitingTime(processes, n);
    findTurnaroundTime(processes, n);

    // Print the results
    printResults(processes, n);

    // Find the average waiting time and average turnaround time
    float avg_waiting_time = findAvgWaitingTime(processes, n);
    float avg_turnaround_time = findAvgTurnaroundTime(processes, n);

    // Print the average waiting time and average turnaround time
    printf("\nAverage waiting time: %.2f ms\n", avg_waiting_time);
    printf("Average turnaround time: %.2f ms\n", avg_turnaround_time);

    return 0;
}