//LLAMA2-13B DATASET v1.0 Category: Memory management ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STR_LEN 256
#define MAX_OBJS 10

typedef struct obj {
    char *name;
    int age;
} obj;

typedef struct memory {
    obj *objects[MAX_OBJS];
    int num_objects;
} memory;

void init_memory(memory *mem) {
    mem->num_objects = 0;
    for (int i = 0; i < MAX_OBJS; i++) {
        mem->objects[i] = NULL;
    }
}

void alloc_object(memory *mem, char *name, int age) {
    int i;
    for (i = 0; i < mem->num_objects; i++) {
        if (mem->objects[i] == NULL) {
            break;
        }
    }
    if (i == mem->num_objects) {
        printf("Out of memory! Cannot allocate object\n");
        return;
    }
    mem->objects[i] = (obj *)malloc(sizeof(obj));
    mem->objects[i]->name = name;
    mem->objects[i]->age = age;
    mem->num_objects++;
}

void dealloc_object(memory *mem, int index) {
    if (mem->objects[index] != NULL) {
        free(mem->objects[index]);
        mem->objects[index] = NULL;
        mem->num_objects--;
    }
}

void print_objects(memory *mem) {
    for (int i = 0; i < mem->num_objects; i++) {
        printf("%s is %d years old\n", mem->objects[i]->name, mem->objects[i]->age);
    }
}

int main() {
    memory mem;
    init_memory(&mem);

    alloc_object(&mem, "John", 25);
    alloc_object(&mem, "Jane", 30);
    alloc_object(&mem, "Bob", 35);

    print_objects(&mem);

    dealloc_object(&mem, 0);
    print_objects(&mem);

    return 0;
}