//Falcon2-11B DATASET v1.0 Category: String manipulation ; Style: paranoid
#include <stdio.h>
#include <string.h>

char* reverseString(char* str) {
    int len = strlen(str);
    char* rev = (char*)malloc(len + 1);
    
    if (rev == NULL) {
        printf("Memory allocation failed\n");
        return NULL;
    }
    
    for (int i = 0; i < len; i++) {
        rev[len - i - 1] = str[i];
    }
    rev[len] = '\0';
    
    return rev;
}

char* concatenateStrings(char* str1, char* str2) {
    int len1 = strlen(str1);
    int len2 = strlen(str2);
    char* concat = (char*)malloc((len1 + len2 + 1) * sizeof(char));
    
    if (concat == NULL) {
        printf("Memory allocation failed\n");
        return NULL;
    }
    
    strcpy(concat, str1);
    strcat(concat, str2);
    
    return concat;
}

int main() {
    char* str1 = "Hello";
    char* str2 = "World";
    
    char* reversedStr1 = reverseString(str1);
    if (reversedStr1 == NULL) {
        printf("Failed to reverse string 1\n");
        return 1;
    }
    
    char* reversedStr2 = reverseString(str2);
    if (reversedStr2 == NULL) {
        printf("Failed to reverse string 2\n");
        free(reversedStr1);
        return 1;
    }
    
    char* concatStr = concatenateStrings(reversedStr1, reversedStr2);
    if (concatStr == NULL) {
        printf("Failed to concatenate strings\n");
        free(reversedStr1);
        free(reversedStr2);
        return 1;
    }
    
    printf("Concatenated string: %s\n", concatStr);
    
    free(reversedStr1);
    free(reversedStr2);
    free(concatStr);
    
    return 0;
}