//Code Llama-13B DATASET v1.0 Category: Networking ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define BUF_SIZE 1024

int main(int argc, char *argv[]) {
    int sock;
    struct sockaddr_in server;
    char buffer[BUF_SIZE];
    size_t bytes_sent, bytes_received;

    // Create a socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket() failed");
        return EXIT_FAILURE;
    }

    // Set up the server address
    memset(&server, 0, sizeof(server));
    server.sin_family = AF_INET;
    server.sin_port = htons(8080);
    server.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to the server
    if (connect(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
        perror("connect() failed");
        return EXIT_FAILURE;
    }

    // Send a message to the server
    strcpy(buffer, "Hello, server!");
    bytes_sent = send(sock, buffer, strlen(buffer), 0);
    if (bytes_sent < 0) {
        perror("send() failed");
        return EXIT_FAILURE;
    }

    // Receive a message from the server
    memset(buffer, 0, BUF_SIZE);
    bytes_received = recv(sock, buffer, BUF_SIZE, 0);
    if (bytes_received < 0) {
        perror("recv() failed");
        return EXIT_FAILURE;
    }

    // Print the received message
    printf("Received message from server: %s\n", buffer);

    // Close the socket
    close(sock);

    return EXIT_SUCCESS;
}