//Falcon-180B DATASET v1.0 Category: Time Travel Simulator ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_EVENTS 100
#define MAX_TIME 10000

// Event structure
typedef struct {
    time_t time;
    char *description;
} Event;

// Function prototypes
void addEvent(Event *events, int numEvents, time_t time, char *description);
void printEvents(Event *events, int numEvents);
void timeTravel(Event *events, int numEvents, time_t targetTime);

int main() {
    Event events[MAX_EVENTS];
    int numEvents = 0;

    // Add some events
    addEvent(events, numEvents, 946684800, "The day we first met");
    addEvent(events, numEvents, 946699200, "Our first date");
    addEvent(events, numEvents, 946714600, "The day we fell in love");
    addEvent(events, numEvents, 946729600, "The day we got engaged");
    addEvent(events, numEvents, 946745200, "Our wedding day");

    // Print the events
    printf("Our love story:\n");
    printEvents(events, numEvents);

    // Time travel to our wedding day
    time_t targetTime = 946745200;
    timeTravel(events, numEvents, targetTime);

    return 0;
}

void addEvent(Event *events, int numEvents, time_t time, char *description) {
    if (numEvents >= MAX_EVENTS) {
        printf("Error: Too many events.\n");
        exit(1);
    }

    events[numEvents].time = time;
    events[numEvents].description = description;

    numEvents++;
}

void printEvents(Event *events, int numEvents) {
    for (int i = 0; i < numEvents; i++) {
        printf("%s (%ld seconds)\n", events[i].description, events[i].time);
    }
}

void timeTravel(Event *events, int numEvents, time_t targetTime) {
    for (int i = 0; i < numEvents; i++) {
        if (events[i].time == targetTime) {
            printf("We've arrived at %s!\n", events[i].description);
            return;
        }
    }

    printf("Error: Time travel failed.\n");
}