//GEMINI-pro DATASET v1.0 Category: Classical Circuit Simulator ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CIRCUIT_SIZE 100
#define MAX_COMPONENT_NAME_SIZE 32

typedef enum {
  RESISTOR,
  CAPACITOR,
  INDUCTOR,
  VOLTAGE_SOURCE,
  CURRENT_SOURCE
} component_type;

typedef struct {
  component_type type;
  char name[MAX_COMPONENT_NAME_SIZE];
  double value;
  int num_nodes;
  int nodes[2];
} component;

typedef struct {
  int num_components;
  component components[MAX_CIRCUIT_SIZE];
} circuit;

void print_circuit(circuit *circuit) {
  for (int i = 0; i < circuit->num_components; i++) {
    component *component = &circuit->components[i];
    printf("%s: ", component->name);
    switch (component->type) {
      case RESISTOR:
        printf("Resistor, ");
        break;
      case CAPACITOR:
        printf("Capacitor, ");
        break;
      case INDUCTOR:
        printf("Inductor, ");
        break;
      case VOLTAGE_SOURCE:
        printf("Voltage source, ");
        break;
      case CURRENT_SOURCE:
        printf("Current source, ");
        break;
    }
    printf("Value: %.2f, ", component->value);
    printf("Nodes: ");
    for (int j = 0; j < component->num_nodes; j++) {
      printf("%d, ", component->nodes[j]);
    }
    printf("\n");
  }
}

int main() {
  circuit circuit = {};

  // Create a resistor
  component resistor = {
    .type = RESISTOR,
    .name = "R1",
    .value = 100,
    .num_nodes = 2,
    .nodes = {1, 2}
  };

  // Add the resistor to the circuit
  circuit.components[circuit.num_components++] = resistor;

  // Create a capacitor
  component capacitor = {
    .type = CAPACITOR,
    .name = "C1",
    .value = 100e-6,
    .num_nodes = 2,
    .nodes = {2, 3}
  };

  // Add the capacitor to the circuit
  circuit.components[circuit.num_components++] = capacitor;

  // Create an inductor
  component inductor = {
    .type = INDUCTOR,
    .name = "L1",
    .value = 100e-3,
    .num_nodes = 2,
    .nodes = {3, 4}
  };

  // Add the inductor to the circuit
  circuit.components[circuit.num_components++] = inductor;

  // Create a voltage source
  component voltage_source = {
    .type = VOLTAGE_SOURCE,
    .name = "V1",
    .value = 10,
    .num_nodes = 2,
    .nodes = {1, 4}
  };

  // Add the voltage source to the circuit
  circuit.components[circuit.num_components++] = voltage_source;

  // Create a current source
  component current_source = {
    .type = CURRENT_SOURCE,
    .name = "I1",
    .value = 1,
    .num_nodes = 2,
    .nodes = {2, 4}
  };

  // Add the current source to the circuit
  circuit.components[circuit.num_components++] = current_source;

  // Print the circuit
  print_circuit(&circuit);

  return 0;
}