//Gemma-7B DATASET v1.0 Category: Procedural Space Adventure ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_ENEMY_COUNT 5
#define MAX_MISSILE_COUNT 3

typedef struct Ship {
    int x, y, health, direction;
    char name[20];
} Ship;

void initializeShips(Ship *ships, int numShips) {
    for (int i = 0; i < numShips; i++) {
        ships[i].x = rand() % 10;
        ships[i].y = rand() % 10;
        ships[i].health = 100;
        ships[i].direction = rand() % 4;
        strcpy(ships[i].name, "Ship " + i);
    }
}

void moveShips(Ship *ships, int numShips) {
    for (int i = 0; i < numShips; i++) {
        switch (ships[i].direction) {
            case 0:
                ships[i].x++;
                break;
            case 1:
                ships[i].y++;
                break;
            case 2:
                ships[i].x--;
                break;
            case 3:
                ships[i].y--;
                break;
        }
    }
}

void attackShips(Ship *ships, int numShips) {
    for (int i = 0; i < numShips; i++) {
        int damage = rand() % MAX_MISSILE_COUNT;
        ships[i].health -= damage;
    }
}

int main() {
    srand(time(NULL));

    Ship ships[MAX_ENEMY_COUNT];
    initializeShips(ships, MAX_ENEMY_COUNT);

    moveShips(ships, MAX_ENEMY_COUNT);

    attackShips(ships, MAX_ENEMY_COUNT);

    for (int i = 0; i < MAX_ENEMY_COUNT; i++) {
        printf("%s health: %d\n", ships[i].name, ships[i].health);
    }

    return 0;
}