//Falcon-180B DATASET v1.0 Category: Database querying ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the structure of a person
typedef struct {
    char name[50];
    int age;
    char gender[10];
    char phone[15];
} Person;

// Function to compare two people based on their age
int compare_age(const void *a, const void *b) {
    const Person *person1 = (const Person *)a;
    const Person *person2 = (const Person *)b;

    if (person1->age > person2->age) {
        return 1;
    } else if (person1->age < person2->age) {
        return -1;
    } else {
        return 0;
    }
}

// Function to compare two people based on their name
int compare_name(const void *a, const void *b) {
    const Person *person1 = (const Person *)a;
    const Person *person2 = (const Person *)b;

    return strcmp(person1->name, person2->name);
}

// Function to print a person's information
void print_person(const Person *person) {
    printf("Name: %s\n", person->name);
    printf("Age: %d\n", person->age);
    printf("Gender: %s\n", person->gender);
    printf("Phone: %s\n", person->phone);
}

int main() {
    // Initialize an array of people
    Person people[] = {
        {"John Doe", 25, "Male", "555-1234"},
        {"Jane Doe", 30, "Female", "555-5678"},
        {"Bob Smith", 40, "Male", "555-9012"},
        {"Alice Johnson", 35, "Female", "555-3456"}
    };

    // Sort the array by age in ascending order
    qsort(people, 4, sizeof(Person), compare_age);

    // Print the sorted array
    printf("Sorted by age in ascending order:\n");
    for (int i = 0; i < 4; i++) {
        print_person(&people[i]);
    }

    // Sort the array by name in ascending order
    qsort(people, 4, sizeof(Person), compare_name);

    // Print the sorted array
    printf("\nSorted by name in ascending order:\n");
    for (int i = 0; i < 4; i++) {
        print_person(&people[i]);
    }

    return 0;
}