//Gemma-7B DATASET v1.0 Category: Personal Finance Planner ; Style: modular
#include <stdio.h>
#include <stdlib.h>

// Define a structure to store financial data
typedef struct FinancialData {
    char name[20];
    int income;
    int expenses;
    int savings;
    int investments;
} FinancialData;

// Function to calculate total financial assets
int calculateTotalAssets(FinancialData *data) {
    return data->savings + data->investments;
}

// Function to calculate total financial liabilities
int calculateTotalLiabilities(FinancialData *data) {
    return data->expenses;
}

// Function to calculate net worth
int calculateNetWorth(FinancialData *data) {
    return calculateTotalAssets(data) - calculateTotalLiabilities(data);
}

int main() {
    // Create a structure instance
    FinancialData data;

    // Populate the structure with sample data
    strcpy(data.name, "John Doe");
    data.income = 50000;
    data.expenses = 20000;
    data.savings = 10000;
    data.investments = 5000;

    // Calculate total assets, liabilities, and net worth
    int totalAssets = calculateTotalAssets(&data);
    int totalLiabilities = calculateTotalLiabilities(&data);
    int netWorth = calculateNetWorth(&data);

    // Print the results
    printf("Name: %s\n", data.name);
    printf("Total Assets: %d\n", totalAssets);
    printf("Total Liabilities: %d\n", totalLiabilities);
    printf("Net Worth: %d\n", netWorth);

    return 0;
}