//MISTRAL-7B DATASET v1.0 Category: Geometric algorithms ; Style: calm
#include <stdio.h>
#include <math.h>

typedef struct {
    double x, y;
} Point;

typedef struct {
    Point start, end;
    double m, b;
} Line;

void find_slope(Line *l, Point p) {
    double dx = l->end.x - l->start.x, dy = l->end.y - l->start.y;

    if (abs(dx) > 1e-9) {
        l->m = dy / dx;
    } else {
        l->m = 1e10;
        l->b = l->start.y;
    }

    l->b -= l->m * l->start.x;
}

Point intersection(Line l1, Line l2) {
    Point inter;

    if (fabs(l1.m - l2.m) > 1e-9) {
        inter.x = (l2.b - l1.b) / (l1.m - l2.m);
        inter.y = l1.m * inter.x + l1.b;
    } else {
        inter.x = 1e10;
        inter.y = 1e10;
    }

    return inter;
}

int main() {
    Line line1 = {{1, 2}, {4, 6}}, line2 = {{3, 1}, {5, 5}};
    Point inter;

    find_slope(&line1, (Point){2, 3});
    find_slope(&line2, (Point){3, 3});

    inter = intersection(line1, line2);

    if (inter.x == 1e10) {
        printf("The lines do not intersect.\n");
    } else {
        printf("The lines intersect at (%lf, %lf).\n", inter.x, inter.y);
    }

    return 0;
}