//GEMINI-pro DATASET v1.0 Category: Building a HTTP Client ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

// Custom data structure to store the response data
typedef struct {
    char *data;
    size_t size;
} ResponseData;

// Write callback function for CURLOPT_WRITEFUNCTION
// This function gets called by libcurl for each block of data received
size_t write_data(void *buffer, size_t size, size_t nmemb, void *userp) {
    ResponseData *data = (ResponseData *)userp;
    // Reallocate the buffer if needed
    if (data->size + (size * nmemb) > data->size) {
        data->data = realloc(data->data, data->size + (size * nmemb));
    }
    // Copy the data to the buffer
    memcpy(data->data + data->size, buffer, size * nmemb);
    data->size += size * nmemb;
    return size * nmemb;
}

int main() {
    // Initialize the libcurl session
    CURL *curl = curl_easy_init();
    if (curl == NULL) {
        fprintf(stderr, "Error: Failed to initialize libcurl.\n");
        return 1;
    }

    // Set the URL to fetch
    curl_easy_setopt(curl, CURLOPT_URL, "https://example.com");

    // Set the write callback function
    ResponseData response_data = {0};
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_data);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, &response_data);

    // Perform the request
    CURLcode res = curl_easy_perform(curl);
    if (res != CURLE_OK) {
        fprintf(stderr, "Error: Failed to perform the request: %s\n", curl_easy_strerror(res));
        curl_easy_cleanup(curl);
        return 2;
    }

    // Get the HTTP response code
    long response_code;
    curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &response_code);
    printf("HTTP Response Code: %ld\n", response_code);

    // Print the response data
    printf("Response Data:\n%s\n", response_data.data);

    // Cleanup the libcurl session
    curl_easy_cleanup(curl);
    free(response_data.data);

    return 0;
}