//Code Llama-13B DATASET v1.0 Category: Temperature Converter ; Style: sophisticated
/*
 * C Temperature Converter
 *
 * This program converts temperatures from one scale to another.
 */

#include <stdio.h>

// Define the different temperature scales
#define CELSIUS 0
#define FAHRENHEIT 1
#define KELVIN 2

// Define the conversion factors
#define C_TO_F (9.0 / 5.0)
#define C_TO_K (273.15)
#define F_TO_C (5.0 / 9.0)
#define F_TO_K (459.67)
#define K_TO_C (273.15)
#define K_TO_F (9.0 / 5.0)

// Define the temperature structure
typedef struct {
    double value;
    int scale;
} temperature_t;

// Define the temperature conversion function
temperature_t convert_temperature(temperature_t temp, int new_scale) {
    temperature_t new_temp;

    switch (new_scale) {
        case CELSIUS:
            new_temp.value = temp.value;
            new_temp.scale = CELSIUS;
            break;
        case FAHRENHEIT:
            new_temp.value = temp.value * C_TO_F + 32.0;
            new_temp.scale = FAHRENHEIT;
            break;
        case KELVIN:
            new_temp.value = temp.value + K_TO_C;
            new_temp.scale = KELVIN;
            break;
        default:
            printf("Invalid temperature scale\n");
            break;
    }

    return new_temp;
}

// Define the temperature print function
void print_temperature(temperature_t temp) {
    switch (temp.scale) {
        case CELSIUS:
            printf("%f°C\n", temp.value);
            break;
        case FAHRENHEIT:
            printf("%f°F\n", temp.value);
            break;
        case KELVIN:
            printf("%f°K\n", temp.value);
            break;
        default:
            printf("Invalid temperature scale\n");
            break;
    }
}

// Define the main function
int main() {
    // Declare a temperature structure
    temperature_t temp;

    // Initialize the temperature structure
    temp.value = 25.0;
    temp.scale = CELSIUS;

    // Convert the temperature to different scales
    temperature_t fahrenheit_temp = convert_temperature(temp, FAHRENHEIT);
    temperature_t kelvin_temp = convert_temperature(temp, KELVIN);

    // Print the converted temperatures
    print_temperature(fahrenheit_temp);
    print_temperature(kelvin_temp);

    return 0;
}