//Falcon-180B DATASET v1.0 Category: Disk space analyzer ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <dirent.h>
#include <sys/statvfs.h>

#define MAX_DIRS 1000
#define MAX_SIZE 1024

typedef struct {
    char dir_path[MAX_SIZE];
    long long total_size;
} dir_t;

dir_t dirs[MAX_DIRS];
int num_dirs = 0;

void *thread_func(void *arg) {
    char *dir_path = (char *)arg;
    struct dirent *dir;
    DIR *dp;
    struct statvfs buf;

    dp = opendir(dir_path);
    if (dp == NULL) {
        return NULL;
    }

    while ((dir = readdir(dp))!= NULL) {
        if (dir->d_type == DT_DIR) {
            snprintf(dirs[num_dirs].dir_path, MAX_SIZE, "%s/%s", dir_path, dir->d_name);
            num_dirs++;
        }
    }

    closedir(dp);

    return NULL;
}

int main() {
    pthread_t threads[MAX_DIRS];
    char cwd[MAX_SIZE];

    if (getcwd(cwd, MAX_SIZE)!= NULL) {
        printf("Current directory: %s\n", cwd);
    } else {
        printf("Error: Unable to get current directory.\n");
        return 1;
    }

    printf("Scanning for directories...\n");
    dir_t root_dir;
    snprintf(root_dir.dir_path, MAX_SIZE, "%s", cwd);
    root_dir.total_size = 0;
    dirs[0] = root_dir;
    num_dirs = 1;

    for (int i = 1; i < num_dirs; i++) {
        pthread_create(&threads[i], NULL, thread_func, (void *)dirs[i].dir_path);
    }

    for (int i = 0; i < num_dirs; i++) {
        pthread_join(threads[i], NULL);
    }

    printf("Directory scan complete.\n");

    for (int i = 0; i < num_dirs; i++) {
        printf("Total size of %s: %lld bytes\n", dirs[i].dir_path, dirs[i].total_size);
    }

    return 0;
}