//GEMINI-pro DATASET v1.0 Category: Remote control Vehicle Simulation ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define MAX_SPEED 10
#define MAX_TURN_ANGLE 45

typedef struct {
    int speed;
    int turn_angle;
    bool is_on;
} car_t;

void init_car(car_t *car) {
    car->speed = 0;
    car->turn_angle = 0;
    car->is_on = false;
}

void turn_on_car(car_t *car) {
    car->is_on = true;
}

void turn_off_car(car_t *car) {
    car->is_on = false;
}

void accelerate(car_t *car, int amount) {
    if (!car->is_on) {
        printf("Car is not on!\n");
        return;
    }

    car->speed += amount;
    if (car->speed > MAX_SPEED) {
        car->speed = MAX_SPEED;
    }
}

void decelerate(car_t *car, int amount) {
    if (!car->is_on) {
        printf("Car is not on!\n");
        return;
    }

    car->speed -= amount;
    if (car->speed < 0) {
        car->speed = 0;
    }
}

void turn_left(car_t *car, int angle) {
    if (!car->is_on) {
        printf("Car is not on!\n");
        return;
    }

    car->turn_angle -= angle;
    if (car->turn_angle < -MAX_TURN_ANGLE) {
        car->turn_angle = -MAX_TURN_ANGLE;
    }
}

void turn_right(car_t *car, int angle) {
    if (!car->is_on) {
        printf("Car is not on!\n");
        return;
    }

    car->turn_angle += angle;
    if (car->turn_angle > MAX_TURN_ANGLE) {
        car->turn_angle = MAX_TURN_ANGLE;
    }
}

void print_car_status(car_t *car) {
    printf("Car status:\n");
    printf("  Speed: %d\n", car->speed);
    printf("  Turn angle: %d\n", car->turn_angle);
    printf("  Is on: %s\n", car->is_on ? "true" : "false");
}

int main() {
    car_t car;

    init_car(&car);
    turn_on_car(&car);
    accelerate(&car, 5);
    turn_left(&car, 10);
    print_car_status(&car);
    decelerate(&car, 2);
    turn_right(&car, 15);
    print_car_status(&car);
    turn_off_car(&car);

    return 0;
}