//Falcon-180B DATASET v1.0 Category: RAM usage monitor ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PROCESSES 1000
#define MAX_PROCESS_NAME_LEN 50
#define MAX_PROCESS_ID_LEN 20

typedef struct {
    char process_name[MAX_PROCESS_NAME_LEN];
    char process_id[MAX_PROCESS_ID_LEN];
    int pid;
    int memory_usage;
} Process;

int num_processes = 0;
Process processes[MAX_PROCESSES];

void add_process(char* name, char* id, int pid) {
    if (num_processes >= MAX_PROCESSES) {
        printf("Error: Maximum number of processes reached.\n");
        return;
    }

    strcpy(processes[num_processes].process_name, name);
    strcpy(processes[num_processes].process_id, id);
    processes[num_processes].pid = pid;
    processes[num_processes].memory_usage = 0;

    num_processes++;
}

void update_process_memory_usage(int pid, int memory_usage) {
    int i;
    for (i = 0; i < num_processes; i++) {
        if (processes[i].pid == pid) {
            processes[i].memory_usage = memory_usage;
            break;
        }
    }
}

void print_processes() {
    printf("Process Name\tProcess ID\tPID\tMemory Usage\n");
    printf("-------------------------------------------------\n");

    int i;
    for (i = 0; i < num_processes; i++) {
        printf("%-50s\t%-20s\t%d\t%d\n",
               processes[i].process_name,
               processes[i].process_id,
               processes[i].pid,
               processes[i].memory_usage);
    }
}

int main() {
    add_process("Google Chrome", "chrome.exe", 1234);
    add_process("Microsoft Word", "winword.exe", 5678);

    update_process_memory_usage(1234, 500);
    update_process_memory_usage(5678, 200);

    print_processes();

    return 0;
}