//LLAMA2-13B DATASET v1.0 Category: Phone Book ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define MAX_NAME_LENGTH 50
#define MAX_PHONE_NUMBER_LENGTH 20
#define MAX_ENTRIES 100

typedef struct {
    char name[MAX_NAME_LENGTH];
    char phone_number[MAX_PHONE_NUMBER_LENGTH];
} entry;

entry phone_book[MAX_ENTRIES];
int num_entries = 0;

void add_entry(char *name, char *phone_number);
void display_entries();
void search_entry(char *name);

int main() {
    char search_name[MAX_NAME_LENGTH];

    // Add some entries to the phone book
    add_entry("John Doe", "555-1234");
    add_entry("Jane Doe", "555-5678");
    add_entry("Bob Smith", "555-9012");

    // Search for an entry
    search_entry("John");

    // Display all entries
    display_entries();

    return 0;
}

void add_entry(char *name, char *phone_number) {
    int i;

    // Find an empty slot in the phone book
    for (i = 0; i < num_entries; i++) {
        if (strcmp(phone_book[i].name, "") == 0) {
            break;
        }
    }

    // If no empty slots were found, wrap around to the beginning of the array
    if (i == num_entries) {
        i = 0;
    }

    strcpy(phone_book[i].name, name);
    strcpy(phone_book[i].phone_number, phone_number);
    num_entries++;
}

void display_entries() {
    int i;

    printf("Phone Book:\n");
    for (i = 0; i < num_entries; i++) {
        printf("%d: %s %s\n", i, phone_book[i].name, phone_book[i].phone_number);
    }
}

void search_entry(char *name) {
    int i;

    for (i = 0; i < num_entries; i++) {
        if (strcmp(phone_book[i].name, name) == 0) {
            printf("Found: %s %s\n", phone_book[i].name, phone_book[i].phone_number);
            break;
        }
    }
}