//Code Llama-13B DATASET v1.0 Category: Client Server Application ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT 8080

int main() {
    int sock, new_sock;
    struct sockaddr_in server, client;
    socklen_t client_len = sizeof(client);
    char buffer[1024];

    // Create the server socket
    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        perror("Socket creation error");
        exit(1);
    }

    // Setup the server address
    memset(&server, 0, sizeof(server));
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons(PORT);

    // Bind the server socket to the address
    if (bind(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
        perror("Bind error");
        exit(1);
    }

    // Listen for incoming connections
    if (listen(sock, 3) < 0) {
        perror("Listen error");
        exit(1);
    }

    // Accept incoming connections
    if ((new_sock = accept(sock, (struct sockaddr *)&client, &client_len)) < 0) {
        perror("Accept error");
        exit(1);
    }

    // Read data from the client
    if (read(new_sock, buffer, 1024) < 0) {
        perror("Read error");
        exit(1);
    }

    // Print the received data
    printf("Received: %s\n", buffer);

    // Close the socket
    close(new_sock);
    close(sock);

    return 0;
}