//LLAMA2-13B DATASET v1.0 Category: Matrix operations ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main(int argc, char **argv) {
    int sock, conn_sock;
    struct sockaddr_in server, client;
    char buffer[256];
    int buffer_size = 256;

    // Create a socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("Socket creation failed");
        exit(EXIT_FAILURE);
    }

    // Set up the server address
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons(PORT);

    // Bind the socket to the address and port
    if (bind(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
        perror("Binding failed");
        exit(EXIT_FAILURE);
    }

    // Listen for incoming connections
    if (listen(sock, 3) < 0) {
        perror("Listening failed");
        exit(EXIT_FAILURE);
    }

    printf("Listening for incoming connections...\n");

    // Accept an incoming connection
    conn_sock = accept(sock, (struct sockaddr *)&client, (socklen_t*)&client.sin_addr);
    if (conn_sock < 0) {
        perror("Accept failed");
        exit(EXIT_FAILURE);
    }

    printf("Connection accepted. Sending matrix...\n");

    // Send the matrix from the client to the server
    for (int i = 0; i < 10; i++) {
        for (int j = 0; j < 10; j++) {
            buffer[i * 10 + j] = i * 10 + j;
        }
    }

    send(conn_sock, buffer, 100, 0);

    // Receive the matrix from the server
    recv(conn_sock, buffer, 100, 0);

    // Print the received matrix
    for (int i = 0; i < 10; i++) {
        for (int j = 0; j < 10; j++) {
            printf("%d ", buffer[i * 10 + j]);
        }
        printf("\n");
    }

    // Close the sockets
    close(sock);
    close(conn_sock);

    return 0;
}