//MISTRAL-7B DATASET v1.0 Category: Sudoku solver ; Style: paranoid
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BOARD_SIZE 9
#define GRID_SIZE (BOARD_SIZE * BOARD_SIZE)

// Paranoid check for invalid input
#define ISVALID(X) (sizeof(X) == 1 && (X >= '0' && X <= '9'))

// Paranoid check for empty grid
bool grid_is_empty(int grid[GRID_SIZE]) {
    bool result = true;
    for (int i = 0; i < GRID_SIZE && result; ++i) {
        result &= grid[i] == 0;
    }
    return result;
}

// Paranoid check for valid move
bool valid_move(int row, int col, int grid[GRID_SIZE], int num) {
    // Check row
    for (int i = col; i >= 0; --i) {
        if (grid[row * BOARD_SIZE + i] != 0 && grid[row * BOARD_SIZE + i] == num) {
            return false;
        }
    }

    // Check column
    for (int i = row; i >= 0; --i) {
        if (grid[i + col] != 0 && grid[i + col] == num) {
            return false;
        }
    }

    // Check box
    int box_row = row - row % 3;
    int box_col = col - col % 3;
    for (int i = box_row * BOARD_SIZE + box_col; i < box_row * BOARD_SIZE + box_col + 3 * BOARD_SIZE; ++i) {
        if (grid[i] != 0 && grid[i] == num) {
            return false;
        }
    }

    return true;
}

// Paranoid Sudoku solver
bool sudoku_solve(int row, int col, int grid[GRID_SIZE]) {
    if (col == BOARD_SIZE) {
        if (++row >= BOARD_SIZE) {
            return grid_is_empty(grid);
        }
        col = 0;
    }

    if (grid[row * BOARD_SIZE + col] != 0) {
        if (sudoku_solve(row, col + 1, grid)) {
            return true;
        }
    } else {
        for (int num = 1; num <= BOARD_SIZE; ++num) {
            if (valid_move(row, col, grid, num)) {
                grid[row * BOARD_SIZE + col] = num;
                if (sudoku_solve(row, col + 1, grid)) {
                    return true;
                }
                grid[row * BOARD_SIZE + col] = 0;
            }
        }
    }

    return false;
}

// Paranoid print grid
void print_grid(int grid[GRID_SIZE]) {
    for (int row = 0; row < BOARD_SIZE; ++row) {
        for (int col = 0; col < BOARD_SIZE; ++col) {
            int num = grid[row * BOARD_SIZE + col];
            if (num == 0) {
                printf(" _ ");
            } else {
                printf(" %d ", num);
            }
        }
        printf("\n");
    }
}

// Paranoid main function
int main(void) {
    int grid[GRID_SIZE] = { 0 };

    // Paranoid check for valid input
    if (scanf("%9s", (char *)grid) != 1 || !grid_is_empty(grid)) {
        fprintf(stderr, "Invalid input\n");
        return EXIT_FAILURE;
    }

    // Paranoid check for solved puzzle
    if (!sudoku_solve(0, 0, grid)) {
        fprintf(stderr, "Puzzle is unsolvable\n");
        return EXIT_FAILURE;
    }

    // Paranoid print solved grid
    printf("Solved grid:\n");
    print_grid(grid);

    return EXIT_SUCCESS;
}