//GEMINI-pro DATASET v1.0 Category: Website Uptime Monitor ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <curl/curl.h>

// Custom data structure to hold website information
struct website_info {
    char *url;
    time_t last_checked;
    int status_code;
};

// Callback function for libcurl to write website response to memory
size_t write_response(void *ptr, size_t size, size_t nmemb, void *stream) {
    struct website_info *info = (struct website_info *)stream;

    // Calculate the size of the response
    size_t total_size = size * nmemb;

    // Create a buffer to store the response
    char *buffer = malloc(total_size + 1);

    // Copy the response into the buffer
    memcpy(buffer, ptr, total_size);

    // Add a null terminator to the buffer
    buffer[total_size] = '\0';

    // Update the website information with the response
    info->status_code = atoi(buffer);

    // Free the buffer
    free(buffer);

    // Return the total size of the response
    return total_size;
}

int main() {
    // Initialize libcurl
    curl_global_init(CURL_GLOBAL_DEFAULT);

    // Initialize the website information
    struct website_info info;
    info.url = "https://example.com";
    info.last_checked = time(NULL);
    info.status_code = -1;

    // Create a curl handle
    CURL *curl = curl_easy_init();

    // Set the URL to fetch
    curl_easy_setopt(curl, CURLOPT_URL, info.url);

    // Set the callback function for writing the website response to memory
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_response);

    // Set the custom data structure to pass to the callback function
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, &info);

    // Perform the website fetch
    CURLcode res = curl_easy_perform(curl);

    // Check if the fetch was successful
    if (res != CURLE_OK) {
        // Print the error message
        fprintf(stderr, "Error fetching website: %s\n", curl_easy_strerror(res));

        // Cleanup libcurl
        curl_easy_cleanup(curl);
        curl_global_cleanup();

        return EXIT_FAILURE;
    }

    // Check if the website is up
    if (info.status_code == 200) {
        // Website is up
        printf("Website is up\n");
    } else {
        // Website is down
        printf("Website is down\n");
    }

    // Cleanup libcurl
    curl_easy_cleanup(curl);
    curl_global_cleanup();

    return EXIT_SUCCESS;
}