//Falcon-180B DATASET v1.0 Category: Cryptographic hash function ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define HASH_LENGTH 32

typedef struct {
    unsigned char hash[HASH_LENGTH];
    int index;
} HashState;

void hash_init(HashState *state) {
    memset(state->hash, 0, HASH_LENGTH);
    state->index = 0;
}

void hash_update(HashState *state, const unsigned char *data, int length) {
    int i;
    for (i = 0; i < length; i++) {
        state->hash[state->index] ^= data[i];
        state->index = (state->index + 1) % HASH_LENGTH;
    }
}

void hash_final(HashState *state, unsigned char *digest) {
    int i;
    for (i = 0; i < HASH_LENGTH; i++) {
        digest[i] = state->hash[i];
    }
}

int main() {
    HashState state;
    unsigned char digest[HASH_LENGTH];
    unsigned char message[] = "Hello, world! ";
    int message_length = strlen(message);

    hash_init(&state);
    hash_update(&state, message, message_length);
    hash_final(&state, digest);

    printf("Message: %s\n", message);
    printf("Digest: ");
    for (int i = 0; i < HASH_LENGTH; i++) {
        printf("%02x", digest[i]);
    }
    printf("\n");

    return 0;
}