//GEMINI-pro DATASET v1.0 Category: Palindrome Checker ; Style: Romeo and Juliet
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

void prologue() {
  printf("Two households, both alike in dignity,\n");
  printf("In fair Verona, where we lay our scene,\n");
  printf("From ancient grudge break to new mutiny,\n");
  printf("Where civil blood makes civil hands unclean.\n");
  printf("\n");
  printf("From forth the fatal loins of these two foes\n");
  printf("A pair of star-cross'd lovers take their life;\n");
  printf("Whose misadventured piteous overthrows\n");
  printf("Do with their death bury their parents' strife.\n");
  printf("\n");
  printf("The fearful passage of their death-mark'd love,\n");
  printf("And the continuance of their parents' rage,\n");
  printf("Which, but their children's end, naught could remove,\n");
  printf("Is now the two hours' traffic of our stage.\n");
  printf("\n");
}

int is_palindrome(char *str) {
  int len = strlen(str);
  for (int i = 0; i < len / 2; i++) {
    if (str[i] != str[len - 1 - i]) {
      return 0;
    }
  }
  return 1;
}

int main() {
  prologue();

  char *lines[] = {
    "Did my heart love till now? for I ne'er saw true beauty till this night.",
    "O Romeo, Romeo! wherefore art thou Romeo?",
    "But soft! what light through yonder window breaks?",
    "Arise, fair sun, and kill the envious moon, who is already sick and pale with grief.",
    "These violent delights have violent ends, and in their triumph die.",
    "If I profane with my unworthiest hand this holy shrine, the gentle sin is this:",
    "Parting is such sweet sorrow, that I shall say good night till it be morrow.",
    "But wherefore art thou Romeo?",
    "Good night, good night! parting is such sweet sorrow,\nThat I shall say good night till it be morrow."
  };

  for (int i = 0; i < sizeof(lines) / sizeof(char *); i++) {
    printf("%s", lines[i]);
    if (is_palindrome(lines[i])) {
      printf(" (Palindrome)\n");
    } else {
      printf("\n");
    }
  }

  return 0;
}