//MISTRAL-7B DATASET v1.0 Category: Networking ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>

#define PORT 8080
#define BUFFER_SIZE 1024

void die(const char *msg) {
    perror(msg);
    exit(1);
}

int main(int argc, char *argv[]) {
    int sockfd, new_sockfd, clilen;
    struct sockaddr_in serv_addr, cli_addr;
    char buffer[BUFFER_SIZE];
    int n;

    // Create socket
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
        die("socket: cannot allocate socket");

    // Configure settings for the server address
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(PORT);

    // Bind the socket to the address and port
    if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0)
        die("bind: cannot bind to port");

    // Listen for incoming connections
    listen(sockfd, 10);

    printf("Waiting for incoming connections...\n");

    // Accept an incoming connection
    clilen = sizeof(cli_addr);
    if ((new_sockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen)) < 0)
        die("accept: cannot accept connection");

    printf("Accepted connection from %s:%d\n", inet_ntoa(cli_addr.sin_addr), ntohs(cli_addr.sin_port));

    // Send a message to the client
    const char *message = "Hello, client!";
    if ((n = send(new_sockfd, message, strlen(message), 0)) < 0)
        die("send: error sending the message");

    printf("Sent message: %s\n", message);

    // Receive a message from the client
    memset(buffer, 0, BUFFER_SIZE);
    if ((n = recv(new_sockfd, buffer, BUFFER_SIZE - 1, 0)) < 0)
        die("recv: error receiving the message");

    printf("Received message: %s\n", buffer);

    // Close the connection
    close(new_sockfd);

    // Close the listening socket
    close(sockfd);

    return 0;
}