//Falcon-180B DATASET v1.0 Category: Tic Tac Toe AI ; Style: grateful
#include <stdio.h>
#include <stdlib.h>

#define SIZE 3

void drawBoard(char board[SIZE][SIZE]) {
    int i, j;
    for (i = 0; i < SIZE; i++) {
        for (j = 0; j < SIZE; j++) {
            printf("%c ", board[i][j]);
        }
        printf("\n");
    }
}

int checkWin(char board[SIZE][SIZE]) {
    int i;

    // Check rows
    for (i = 0; i < SIZE; i++) {
        if (board[i][0] == board[i][1] && board[i][1] == board[i][2]) {
            return 1;
        }
    }

    // Check columns
    for (i = 0; i < SIZE; i++) {
        if (board[0][i] == board[1][i] && board[1][i] == board[2][i]) {
            return 1;
        }
    }

    // Check diagonals
    if (board[0][0] == board[1][1] && board[1][1] == board[2][2]) {
        return 1;
    }
    if (board[0][2] == board[1][1] && board[1][1] == board[2][0]) {
        return 1;
    }

    return 0;
}

int main() {
    char board[SIZE][SIZE];

    // Initialize board
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            board[i][j] = '-';
        }
    }

    // Game loop
    while (1) {
        int player = 1;
        int move = 0;
        int won = 0;

        // Draw board
        drawBoard(board);

        // Get player move
        while (move < 0 || move > 8) {
            printf("Player %d, enter your move (1-9): ", player);
            scanf("%d", &move);
            move--; // Convert to 0-based index
        }

        // Check for win
        if (checkWin(board)) {
            printf("Player %d wins!\n", player);
            break;
        }

        // Place mark
        if (player == 1) {
            board[move / 3][move % 3] = 'X';
        } else {
            board[move / 3][move % 3] = 'O';
        }

        // Switch player
        player = (player == 1)? 2 : 1;
    }

    return 0;
}