//Code Llama-13B DATASET v1.0 Category: Personal Finance Planner ; Style: shape shifting
// C Personal Finance Planner Example Program
#include <stdio.h>
#include <stdlib.h>

// Struct for storing data
typedef struct {
  int balance;
  int income;
  int expenses;
  int savings;
} FinanceData;

// Function for updating the data
void updateFinanceData(FinanceData* data, int income, int expenses, int savings) {
  data->income += income;
  data->expenses += expenses;
  data->savings += savings;
}

// Function for calculating the net worth
int calculateNetWorth(FinanceData* data) {
  return data->balance + data->savings - data->expenses;
}

// Function for calculating the monthly expenses
int calculateMonthlyExpenses(FinanceData* data) {
  return data->expenses / 12;
}

// Function for calculating the monthly savings
int calculateMonthlySavings(FinanceData* data) {
  return data->savings / 12;
}

// Function for calculating the savings rate
int calculateSavingsRate(FinanceData* data) {
  return data->savings / (data->savings + data->expenses);
}

// Main function
int main() {
  // Initialize the data
  FinanceData data = {1000, 5000, 3000, 2000};

  // Update the data
  updateFinanceData(&data, 4000, 2500, 1500);

  // Print the net worth
  printf("Net worth: %d\n", calculateNetWorth(&data));

  // Print the monthly expenses
  printf("Monthly expenses: %d\n", calculateMonthlyExpenses(&data));

  // Print the monthly savings
  printf("Monthly savings: %d\n", calculateMonthlySavings(&data));

  // Print the savings rate
  printf("Savings rate: %d%%\n", calculateSavingsRate(&data));

  return 0;
}