//Falcon-180B DATASET v1.0 Category: Database querying ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

static int callback(void *data, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i]? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

int main() {
    sqlite3 *db;
    int rc;
    char *zErrMsg = 0;
    const char *sql;
    char *sql_stmt;

    // Open the database
    rc = sqlite3_open("test.db", &db);
    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Create a table
    sql = "CREATE TABLE IF NOT EXISTS users("
            "id INTEGER PRIMARY KEY,"
            "name TEXT,"
            "age INTEGER);";
    rc = sqlite3_exec(db, sql, NULL, NULL, &zErrMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    }

    // Insert data into the table
    sql_stmt = "INSERT INTO users (name, age) VALUES ('John', 30);";
    rc = sqlite3_exec(db, sql_stmt, NULL, NULL, &zErrMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    }

    // Query the table
    sql_stmt = "SELECT * FROM users;";
    rc = sqlite3_exec(db, sql_stmt, callback, NULL, &zErrMsg);
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    }

    // Close the database
    sqlite3_close(db);
    return 0;
}