//LLAMA2-13B DATASET v1.0 Category: Encryption ; Style: recursive
#include <stdio.h>
#include <string.h>
#include <stdbool.h>

#define KEY_SIZE 5
#define MAX_MESSAGE_LENGTH 256

bool encrypt(char *message, size_t message_len, char *key) {
  if (message_len <= 0 || key == NULL) {
    return false;
  }

  size_t key_len = strlen(key);
  if (key_len != KEY_SIZE) {
    return false;
  }

  char *encrypted_message = malloc(message_len * 2);
  if (encrypted_message == NULL) {
    return false;
  }

  size_t index = 0;
  for (size_t i = 0; i < message_len; i++) {
    char current_char = message[i];
    if (current_char >= 'a' && current_char <= 'z') {
      // Encrypt lowercase letters
      encrypted_message[index] = (current_char + (key[i % key_len] - 'a' + 'z')) % 'z' + 'a';
    } else if (current_char >= 'A' && current_char <= 'Z') {
      // Encrypt uppercase letters
      encrypted_message[index] = (current_char + (key[i % key_len] - 'A' + 'Z')) % 'Z' + 'A';
    } else {
      // Encrypt numbers and special characters
      encrypted_message[index] = (current_char + (key[i % key_len] - '0' + '9')) % '9' + '0';
    }
    index++;
  }

  // Handle the last character of the message
  if (index < message_len) {
    encrypted_message[index] = message[message_len - 1];
  }

  return true;
}

int main() {
  char message[] = "Hello, world!";
  char key[] = "zxcvbnm";
  size_t message_len = strlen(message);

  if (!encrypt(message, message_len, key)) {
    printf("Error: Encryption failed.\n");
    return 1;
  }

  printf("Encrypted message: %s\n", message);

  return 0;
}