//GPT-4o-mini DATASET v1.0 Category: Network Quality of Service (QoS) monitor ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <errno.h>
#include <time.h>

#define PORT 9090
#define BUF_SIZE 1024
#define SAMPLING_INTERVAL 1 // in seconds
#define MAX_REPORTS 10

typedef struct {
    char ip[INET_ADDRSTRLEN];
    int packet_loss;
    float latency;
} NetworkSample;

void logStatus(NetworkSample sample) {
    FILE *logFile = fopen("network_qos_log.txt", "a");
    if (logFile == NULL) {
        perror("Could not open log file");
        return;
    }
    fprintf(logFile, "IP: %s, Packet Loss: %d%%, Latency: %.2fms\n",
            sample.ip, sample.packet_loss, sample.latency);
    fclose(logFile);
}

void simulateNetworkConditions(NetworkSample *sample) {
    // Simulate latency between 20 to 200ms
    sample->latency = (rand() % 181 + 20); // latencies between 20ms to 200ms
    sample->packet_loss = (rand() % 10); // packet loss between 0% to 9%
    
    // Simulate an IP address
    snprintf(sample->ip, INET_ADDRSTRLEN, "192.168.1.%d", rand() % 256);
}

void displayNetworkStats(NetworkSample *samples, int count) {
    printf("%-15s %-15s %-15s\n", "IP Address", "Packet Loss", "Latency");
    for (int i = 0; i < count; ++i) {
        printf("%-15s %-15d%% %-15.2fms\n", samples[i].ip, samples[i].packet_loss, samples[i].latency);
    }
}

int main() {
    srand(time(NULL));

    NetworkSample samples[MAX_REPORTS];
    int sample_count = 0;

    printf("Cyberpunk Network Quality of Service Monitor v1.0\n");
    printf("Entering the neon-lit net of diagnostics...\n");

    while (sample_count < MAX_REPORTS) {
        printf("Sampling network conditions...\n");
        simulateNetworkConditions(&samples[sample_count]);

        logStatus(samples[sample_count]);
        sample_count++;

        printf("Sampled data for %d/%d:\n", sample_count, MAX_REPORTS);
        displayNetworkStats(samples, sample_count);
        
        sleep(SAMPLING_INTERVAL);
    }

    printf("Sampling complete. Check network_qos_log.txt for log details.\n");
    return 0;
}